#!/usr/bin/env python3
"""
Passphrase Cracker Wordlist Generator wordwordword and wordwordwordword
by Javantea
Oct 25, 2014

Based on passphrase1b.py, but goes from 3 to 4.
100 words takes: 100*100*100 + 100*100*100*100 = 101 000 000

It worked on the first try. Something went crazy right here.

python3 -O ../crack/passphrase/passphrase11.py ../crack/ai3words_order_lower_digits_100.txt  |~/src/john-1.7.9-jumbo-5/run/john --config=/home/jvoss/.john/john.conf --session=pp7a --stdin --format=nsec3-sha1 --external=DNS hashes4comu.txt
Loaded 396191 password hashes with no different salts (DNSSEC NSEC3 SHA-1 [32/64])
Remaining 206047 password hashes with no different salts

noonethemallcom (?)

no1themallcom  (?)

"""
from __future__ import print_function
import sys

# filename = '/home/jvoss/pfm_big/wordlists/rockyou1_order.txt'
filename = '/usr/share/dict/words'
if len(sys.argv) > 1:
	filename = sys.argv[1]
#end if
skipto = 0
if len(sys.argv) > 2:
	skipto = int(sys.argv[2])
#end if

wordlist = open(filename, 'r').read().split('\n')

currpos = 0
for currlen in range(3,5):
	x_total = len(wordlist) ** currlen
	start = 0
	print(currpos, skipto)
	if currpos < skipto:
		if skipto > (currpos + x_total):
			# Skip this
			currpos += x_total
			continue
		else:
			start = skipto-currpos
		#end if
	#end if

	# Initialize in case we're skipping to a position.
	passphrase_v = ''.join([wordlist[(start // (len(wordlist) ** i)) % len(wordlist)] for i in range(1, currlen)])
	for x in range(start, x_total):
		# TODO: This can easily be optimized.
		least = x % len(wordlist)
		if least == 0:
			passphrase_v = ''.join([wordlist[(x // (len(wordlist) ** i)) % len(wordlist)] for i in range(1, currlen)])
		#end if
		passphrase = wordlist[least] + passphrase_v
		print(passphrase)
	#next x
	currpos += x_total
#next currlen


