#!/usr/bin/env python3
"""
Passphrase Cracker Wordlist Generator
by Javantea
Oct 25, 2014

It worked on the first try. Something went crazy right here.

python3 ../crack/passphrase1.py wordlist | john --stdin file

This only goes two levels in. This takes wordlist_len*wordlist_len + 
wordlist_len time. You can use a longer wordlist than passphrase1.py and 
passphrase1a.py (both are functionally equivalent but passphrase1a is faster at 
the cost of complexity).
"""
from __future__ import print_function
import sys

# filename = '/home/jvoss/pfm_big/wordlists/rockyou1_order.txt'
filename = '/usr/share/dict/words'
if len(sys.argv) > 1:
	filename = sys.argv[1]
#end if
skipto = 0
if len(sys.argv) > 2:
	skipto = int(sys.argv[2])
#end if

wordlist = open(filename, 'r').read().split('\n')

currpos = 0
for currlen in range(1,2):
	x_total = len(wordlist) ** currlen
	start = 0
	print(currpos, skipto)
	if currpos < skipto:
		if skipto > (currpos + x_total):
			# Skip this
			currpos += x_total
			continue
		else:
			start = skipto-currpos
		#end if
	#end if

	# Initialize in case we're skipping to a position.
	passphrase_v = ''.join([wordlist[(start // (len(wordlist) ** i)) % len(wordlist)] for i in range(1, currlen)])
	for x in range(start, x_total):
		# TODO: This can easily be optimized.
		least = x % len(wordlist)
		if least == 0:
			passphrase_v = ''.join([wordlist[(x // (len(wordlist) ** i)) % len(wordlist)] for i in range(1, currlen)])
		#end if
		passphrase = wordlist[least] + passphrase_v
		print(passphrase)
	#next x
	currpos += x_total
#next currlen


