/*
 * Passphrase 2 xyzword
 * by Javantea
 * Feb 15, 2015
 * 
 * Replacement for passphrase3.py
 * Outputs 2495376 lines in 0.603 seconds.
 * passphrase3.py takes 18.247 seconds.
 * 
 * Read the whole wordlist into memory so you can order the output in the 
 * most beneficial way.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <math.h>

int main(int argc, char **argv)
{
	const char alphabet[] = "abcdefghijklmnopqrstuvwxyz012345679-";
	const int letters = sizeof(alphabet) - 1;
	if(argc <= 1)
	{
		printf("Usage: passphrase3 wordlist\n");
		return 1;
	}
	// Longest word is way longer than legitimate passwords.
	char *data = 0;
	int wordlist_len = 100000;
	int wordlist_pos = 0;
	char **wordlist = (char **)malloc(wordlist_len * sizeof(char *));
	if(wordlist == 0)
	{
		perror("malloc");
		return 1;
	}
	//char buf[1024];
	FILE *f = fopen(argv[1], "r");
	if(f == 0)
	{
		perror("fopen");
		return 1;
	}
	fseek(f, 0, SEEK_END);
	long data_size = ftell(f);
	fseek(f, 0, SEEK_SET);
	// You never know when you're going to need some extra space.
	data = (char *)malloc(data_size + 100);
	if(data == 0)
	{
		perror("malloc");
		return 1;
	}
	int rb = fread(data, data_size, 1, f);
	if(rb != 1 && data_size != 0)
	{
		perror("fread");
		return 1;
	}
	fclose(f);
	// The first word at the start of the file.
	wordlist[0] = data;
	wordlist_pos = 1;
	char *r = data;
	while(((r-data)< data_size))
	{
		r++;
		if(*r == '\n')
		{
			*r = 0;
			char *word = r+1;
			//printf("pw %s\n", wordlist[wordlist_pos-1]);
			wordlist[wordlist_pos] = word;
			wordlist_pos++;
			if(wordlist_pos >= wordlist_len-1)
			{
				wordlist_len += 100000;
				if(wordlist_len < wordlist_pos)
				{
					// This should be practically impossible.
					fprintf(stderr, "Error: wordlist_len may have overflowed %i\n", wordlist_len);
					return 1;
				}
				if(wordlist_len > (INT_MAX / sizeof(char *)))
				{
					// This should be practically impossible.
					fprintf(stderr, "Error: wordlist_len would have overflowed %i\n", wordlist_len);
					return 1;
				}
				wordlist = (char **)realloc(wordlist, wordlist_len * sizeof(char *));
				if(wordlist == 0)
				{
					perror("realloc");
					return 1;
				}
			}
		}
	}
	
	int w;
	int i;
	for(w = 0; w < wordlist_pos; w++)
	{
		for(i = 0; i < letters; i++)
		{
			fputc(alphabet[i], stdout);
			fputs(wordlist[w], stdout);
			fputc('\n', stdout);
		}
	}
	for(w = 0; w < wordlist_pos; w++)
	{
		for(i = 0; i < letters; i++)
		{
			int j;
			for(j = 0; j < letters; j++)
			{
				fputc(alphabet[i], stdout);
				fputc(alphabet[j], stdout);
				fputs(wordlist[w], stdout);
				fputc('\n', stdout);
			}
		}
	}
	long total_rounds_per_word = powl(letters, 3);
	int v;
	for(w = 0; w < wordlist_pos; w++)
	{
		for(v = 0; v < total_rounds_per_word; v++)
		{
			// Verified in python, this is equivalent to multiple for loops.
			int i = v / (letters * letters);
			int j = (v / letters) - (i * letters);
			int k = v - (j * letters) - (i * letters * letters);
			fputc(alphabet[i], stdout);
			fputc(alphabet[j], stdout);
			fputc(alphabet[k], stdout);
			fputs(wordlist[w], stdout);
			fputc('\n', stdout);
		}
	}
	free(data);
	free(wordlist);
	return 0;
}
