#!/usr/bin/env python3
"""
Passphrase Cracker Wordlist Generator Mode xyzword IDN punycoded
by Javantea
Jan 24, 2015
Based on passphrase3punycode.py
Oct 25, 2014

word and characters with IDN support. The characters are still alphanumeric but 
the wordlist can be fully UTF-8.

It worked on the first try. Something went crazy right here.

python3 ../crack/passphrase2punycode.py wordlist | john --stdin file
"""
from __future__ import print_function
import sys
import string

# filename = '/home/jvoss/pfm_big/wordlists/rockyou1_order.txt'
filename = '/usr/share/dict/words'
if len(sys.argv) > 1:
	filename = sys.argv[1]
#end if

wordlist = open(filename, 'r').read().split('\n')
alphabet = string.ascii_lowercase + string.digits
alen = len(alphabet)

for currlen in range(1,4):
	x_total = len(alphabet) ** currlen
	for x in range(x_total):
		# TODO: This can easily be optimized.
		for word in wordlist:
			passphrase = 'xn--' + ((''.join([alphabet[(x // (alen**i)) % alen] for i in range(currlen)]) + word).encode('punycode').decode('ascii'))
			print(passphrase)
		#next word
	#next x
#next currlen


