/*
 * Passphrase 3_5 wordwxyz and wordvwxyz
 * by Javantea
 * Feb 15, 2015
 * 
 * Replacement for passphrase3_5.py
 * Outputs 124M lines in 32.5 seconds.
 * passphrase3_5.py takes 18m58s seconds.
One of the most common uses:
../crack/passphrase/passphrase3_5 blank.txt | ~/src/john-1.7.9-jumbo-5/run/john --config="$HOME"/.john/john.conf --stdin --format=nsec3-sha1-salt-sse --external=DNScom --session=com3_5 auto/hashes_com.txt
 guesses: 0  time: 0:00:02:32  c/s: 71235M  trying: ----2com - -----com

This shows that a single round of SHA1 and comparing against 174231 hashes is 
5x more expensive than outputting the characters. 10 rounds is closer to 13x 
more expensive.

 * Read the whole wordlist into memory so you can order the output in the 
 * most beneficial way.
 * 
 * TODO: Use getWordlist from passphrase7.
 */
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <math.h>

int main(int argc, char **argv)
{
	const char alphabet[] = "abcdefghijklmnopqrstuvwxyz012345679-";
	const int letters = sizeof(alphabet)-1;
	if(argc <= 1)
	{
		printf("Usage: passphrase3 wordlist\n");
		return 1;
	}
	// Longest word is way longer than legitimate passwords.
	char *data = 0;
	int wordlist_len = 100000;
	int wordlist_pos = 0;
	char **wordlist = (char **)malloc(wordlist_len * sizeof(char *));
	if(wordlist == 0)
	{
		perror("malloc");
		return 1;
	}
	//char buf[1024];
	FILE *f = fopen(argv[1], "r");
	if(f == 0)
	{
		perror("fopen");
		return 1;
	}
	fseek(f, 0, SEEK_END);
	long data_size = ftell(f);
	fseek(f, 0, SEEK_SET);
	// You never know when you're going to need some extra space.
	data = (char *)malloc(data_size + 100);
	if(data == 0)
	{
		perror("malloc");
		return 1;
	}
	int rb = fread(data, data_size, 1, f);
	if(rb != 1 && data_size != 0)
	{
		perror("fread");
		return 1;
	}
	fclose(f);
	// The first word at the start of the file.
	wordlist[0] = data;
	wordlist_pos = 1;
	char *r = data;
	while(((r-data)< data_size))
	{
		r++;
		if(*r == '\n')
		{
			*r = 0;
			char *word = r+1;
			//printf("pw %s\n", wordlist[wordlist_pos-1]);
			wordlist[wordlist_pos] = word;
			wordlist_pos++;
			if(wordlist_pos >= wordlist_len-1)
			{
				wordlist_len += 100000;
				if(wordlist_len < wordlist_pos)
				{
					// This should be practically impossible.
					fprintf(stderr, "Error: wordlist_len may have overflowed %i\n", wordlist_len);
					return 1;
				}
				if(wordlist_len > (INT_MAX / sizeof(char *)))
				{
					// This should be practically impossible.
					fprintf(stderr, "Error: wordlist_len would have overflowed %i\n", wordlist_len);
					return 1;
				}
				wordlist = (char **)realloc(wordlist, wordlist_len * sizeof(char *));
				if(wordlist == 0)
				{
					perror("realloc");
					return 1;
				}
			}
		}
	}
	
	// 4 letters
	int w;
	long total_rounds_per_word = powl(letters, 4);
	int v;
	for(w = 0; w < wordlist_pos; w++)
	{
		for(v = 0; v < total_rounds_per_word; v++)
		{
			int letters_sq   = letters * letters;
			int letters_cube = letters_sq * letters;
			
			int i = v / (letters_cube);
			int j = (v / letters_sq) - (i * letters);
			int k = (v / letters) - (j * letters) - (i * letters_sq);
			int m = v - (k * letters) - (j * letters_sq) - (i * letters_cube);
			fputs(wordlist[w], stdout);
			fputc(alphabet[i], stdout);
			fputc(alphabet[j], stdout);
			fputc(alphabet[k], stdout);
			fputc(alphabet[m], stdout);
			fputc('\n', stdout);
		}
	}
	// 5 letters
	total_rounds_per_word = powl(letters, 5);
	for(w = 0; w < wordlist_pos; w++)
	{
		for(v = 0; v < total_rounds_per_word; v++)
		{
			int letters_sq   = letters * letters;
			int letters_cube = letters_sq * letters;
			int letters_pow4 = letters_cube * letters;
			
			int i = v / (letters_pow4);
			int j = (v / letters_cube) - (i * letters);
			int k = (v / letters_sq) - (j * letters) - (i * letters_sq);
			int m = (v / letters) - (k * letters) - (j * letters_sq) - (i * letters_cube);
			int n = v - (m * letters) - (k * letters_sq) - (j * letters_cube) - (i * letters_pow4);
			fputs(wordlist[w], stdout);
			fputc(alphabet[i], stdout);
			fputc(alphabet[j], stdout);
			fputc(alphabet[k], stdout);
			fputc(alphabet[m], stdout);
			fputc(alphabet[n], stdout);
			fputc('\n', stdout);
		}
	}
	free(data);
	free(wordlist);
	return 0;
}
