/*
 * Passphrase 7 wordword
 * by Javantea
 * Feb 16, 2015
 * Based on Passphrase 3 wordxyz
 * by Javantea
 * Feb 15-16, 2015
 * 
 * Replacement for passphrase7.py
 * Outputs 1002001 lines in 0.413 seconds.
 * passphrase7.py takes 4.327 seconds.
 * This gives us a factor of 10 improvement in speed.
 * 
 * TODO: skipto just like passphrase7.py should be very easy.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

char **getWordlist(char *filename, int *wordlist_len, char **data_out)
{
	char *data = 0;
	// We could guess wordlist_size based on the file size if we wanted to.
	int wordlist_size = 100000;
	int wordlist_pos = 0;
	char **wordlist = (char **)malloc(wordlist_size * sizeof(char *));
	if(wordlist == 0)
	{
		perror("malloc");
		exit(1);
	}
	//char buf[1024];
	FILE *f = fopen(filename, "r");
	if(f == 0)
	{
		perror("fopen");
		return 0;
	}
	fseek(f, 0, SEEK_END);
	long data_size = ftell(f);
	fseek(f, 0, SEEK_SET);
	// You never know when you're going to need some extra space.
	data = (char *)malloc(data_size + 100);
	if(data == 0)
	{
		perror("malloc");
		exit(1);
	}
	int rb = fread(data, data_size, 1, f);
	if(rb != 1)
	{
		perror("fread");
		fclose(f);
		return 0;
	}
	fclose(f);
	// The first word at the start of the file.
	wordlist[0] = data;
	wordlist_pos = 1;
	char *r = data;
	while(((r-data)< data_size))
	{
		r++;
		if(*r == '\n')
		{
			*r = 0;
			char *word = r+1;
			//printf("pw %s\n", wordlist[wordlist_pos-1]);
			wordlist[wordlist_pos] = word;
			wordlist_pos++;
			if(wordlist_pos >= wordlist_size-1)
			{
				wordlist_size += 100000;
				if(wordlist_size < wordlist_pos)
				{
					// This should be practically impossible.
					fprintf(stderr, "Error: wordlist_size may have overflowed %i\n", wordlist_size);
					return 0;
				}
				if(wordlist_size > (INT_MAX / sizeof(char *)))
				{
					// This should be practically impossible.
					fprintf(stderr, "Error: wordlist_size would have overflowed %i\n", wordlist_size);
					return 0;
				}
				wordlist = (char **)realloc(wordlist, wordlist_size * sizeof(char *));
				if(wordlist == 0)
				{
					perror("realloc");
					exit(1);
				}
			}
		}
	}
	*wordlist_len = wordlist_pos;
	*data_out = data;
	return wordlist;
}

int main(int argc, char **argv)
{
	if(argc <= 2)
	{
		printf("Usage: passphrase7 wordlist1 wordlist2\n");
		return 1;
	}
	int wordlist1_pos = 0, wordlist2_pos = 0;
	char *data1 = 0, *data2=0;
	char **wordlist1 = getWordlist(argv[1], &wordlist1_pos, &data1);
	if(wordlist1 == 0)
	{
		fprintf(stderr, "Error: wordlist1 failed: %s\n", argv[1]);
		return 1;
	}
	char **wordlist2 = 0;
	if(strcmp(argv[1], argv[2]) == 0)
	{
		// There's no need to double our memory usage if they just want 
		// the functionality of passphrase1a.py.
		wordlist2 = wordlist1;
		wordlist2_pos = wordlist1_pos;
	}
	else
	{
		wordlist2 = getWordlist(argv[2], &wordlist2_pos, &data2);
		if(wordlist2 == 0)
		{
			fprintf(stderr, "Error: wordlist2 failed: %s\n", argv[2]);
			return 1;
		}
	}
	
	int w;
	int i;
	for(w = 0; w < wordlist1_pos; w++)
	{
		for(i = 0; i < wordlist2_pos; i++)
		{
			fputs(wordlist2[i], stdout);
			fputs(wordlist1[w], stdout);
			fputc('\n', stdout);
		}
	}
	if(wordlist2 != wordlist1)
	{
		free(wordlist2);
		free(data2);
	}
	free(wordlist1);
	free(data1);
	return 0;
}
