#!/usr/bin/env python3
"""
Passphrase Cracker Wordlist Generator wordword
by Javantea
Oct 25, 2014

Using two wordlists.

It worked on the first try. Something went crazy right here.

python3 ../crack/passphrase8.py wordlist1 wordlist2 [skipto] | john --stdin file

This is a copy of passphrase7 but reversed. It's important because reverse word 
order. wordlist1 should be the long wordlist, wordlist2 should be a short 
wordlist. The reverse comes up with the same wordlist but in a far inferior 
order.

"""
from __future__ import print_function
import sys

# filename = '/home/jvoss/pfm_big/wordlists/rockyou1_order.txt'
filename1 = '/usr/share/dict/words'
if len(sys.argv) > 1:
	filename1 = sys.argv[1]
#end if
filename2 = '/usr/share/dict/words'
if len(sys.argv) > 2:
	filename2 = sys.argv[2]
#end if
skipto = 0
if len(sys.argv) > 3:
	skipto = int(sys.argv[3])
#end if

wordlist1 = open(filename1, 'r').read().split('\n')
wordlist2 = open(filename2, 'r').read().split('\n')

currpos = 0
x_total = len(wordlist1) * len(wordlist2)
start = 0
#print(currpos, skipto)
if currpos < skipto:
	if skipto > (currpos + x_total):
		# Skip this
		currpos += x_total
		exit(1)
	else:
		start = skipto-currpos
	#end if
#end if

# Initialize in case we're skipping to a position.
passphrase_v = wordlist1[start // len(wordlist2)]
for x in range(start, x_total):
	# TODO: This can easily be optimized.
	least = x % len(wordlist2)
	if least == 0:
		passphrase_v = wordlist1[x // len(wordlist2)]
	#end if
	passphrase = passphrase_v + wordlist2[least]
	print(passphrase)
#next x


